<?php
// Ruta a tu archivo .db.db
$dbFile = __DIR__ . "/.db.db";

try {
    // Conectar a SQLite
    $db = new PDO("sqlite:$dbFile");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtener todas las tablas
    $stmt = $db->query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (!$tables) {
        echo "No se encontraron tablas en la base de datos.";
        exit;
    }

    foreach ($tables as $table) {
        echo "<h3>Tabla: " . htmlspecialchars($table) . "</h3>";

        // Obtener columnas y su estructura
        $stmtCols = $db->query("PRAGMA table_info('$table');");
        $columns = $stmtCols->fetchAll(PDO::FETCH_ASSOC);

        if ($columns) {
            echo "<table border='1' cellpadding='5' cellspacing='0'>";
            echo "<tr><th>Nombre</th><th>Tipo</th><th>NOT NULL</th><th>Valor por defecto</th><th>PK</th></tr>";
            foreach ($columns as $col) {
                echo "<tr>";
                echo "<td>" . htmlspecialchars($col['name']) . "</td>";
                echo "<td>" . htmlspecialchars($col['type']) . "</td>";
                echo "<td>" . ($col['notnull'] ? 'Sí' : 'No') . "</td>";
                echo "<td>" . htmlspecialchars($col['dflt_value']) . "</td>";
                echo "<td>" . ($col['pk'] ? 'Sí' : 'No') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "No se encontraron columnas para esta tabla.";
        }

        // Opcional: mostrar índices
        $stmtIndex = $db->query("PRAGMA index_list('$table');");
        $indexes = $stmtIndex->fetchAll(PDO::FETCH_ASSOC);
        if ($indexes) {
            echo "<strong>Índices:</strong><ul>";
            foreach ($indexes as $idx) {
                echo "<li>" . htmlspecialchars($idx['name']) . " (Único: " . ($idx['unique'] ? 'Sí' : 'No') . ")</li>";
            }
            echo "</ul>";
        }

        echo "<hr>";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
